<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFinBillsTable extends Migration {

	public function up()
	{
		Schema::create('fin_bills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('project_id')->unsigned()->nullable();
			$table->integer('contact_id')->unsigned()->nullable();
			$table->integer('category_id')->unsigned()->nullable();
			$table->tinyInteger('direction')->index()->default('1');
			$table->decimal('total_amount', 10,2);
			$table->string('name')->nullable();
			$table->text('moreinfo')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('fin_bills');
	}
}