<?php

namespace App;

class Page extends Eloquent {

	protected $table = 'page';
	public $timestamps = true;

	public function template()
	{
		return $this->belongsTo('Template');
	}

	public function page_type()
	{
		return $this->belongsTo('PageType');
	}

	public function parent()
	{
		return $this->belongsTo('Page', 'id');
	}

	public function childs()
	{
		return $this->hasMany('Page', 'page_id');
	}

	public function author()
	{
		return $this->belongsTo('User');
	}

	public function comments()
	{
		return $this->hasMany('Comment');
	}

	public function meta()
	{
		return $this->hasMany('PageMeta');
	}

	public function menu()
	{
		return $this->hasOne('Menu');
	}

	public function widgets()
	{
		return $this->hasMany('Widget');
	}

}