<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Car extends Model 
{

    protected $table = 'cars';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function products()
    {
        return $this->hasMany('app\Product');
    }

    public function model()
    {
        return $this->hasOne('app\Model');
    }

}