<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'avatar', 'phone', 'type', 'status', 'code', 'address', 'city_id', 'lat', 'long');

    public function city()
    {
        return $this->belongsTo('City', 'id');
    }

    public function products()
    {
        return $this->hasMany('app\Users');
    }

}