<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'avatar', 'phone', 'type', 'status', 'code', 'address', 'city_id', 'lat', 'long');

	public function city()
	{
		return $this->belongsTo('City', 'id');
	}

	public function products()
	{
		return $this->hasMany('app\Users');
	}

}