<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->string('email', 50);
			$table->string('description', 80);
			$table->float('discount');
			$table->float('sub_total');
			$table->float('total');
			$table->tinyInteger('status');
			$table->string('address', 100);
			$table->string('address_city', 30);
			$table->string('phone_number', 15);
			$table->string('currency_code', 3);
			$table->string('country_code', 2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}