<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Course extends Model 
{

    protected $table = 'courses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'objective', 'authors', 'tags', 'image', 'campaigns');

    public function authors()
    {
        return $this->hasMany('App\User');
    }

    public function campaigns()
    {
        return $this->hasMany('App\Campaign');
    }

}