<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlocksTable extends Migration {

	public function up()
	{
		Schema::create('blocks', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('document', 'video', 'challenge'));
			$table->json('tags');
			$table->json('content');
			$table->integer('difficulty');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('practice');
		});
	}

	public function down()
	{
		Schema::drop('blocks');
	}
}