<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMetricsTable extends Migration {

	public function up()
	{
		Schema::create('metrics', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('timestamp');
			$table->string('name');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('mission_id')->unsigned();
			$table->json('content')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('metrics');
	}
}