<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMissionsTable extends Migration {

	public function up()
	{
		Schema::create('missions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('name');
			$table->text('description');
			$table->text('objective');
			$table->string('image');
			$table->json('tags');
			$table->integer('dificulty');
			$table->json('practice_blocks')->default('[1001,1002,1003]');
			$table->json('challenge_blocks');
			$table->json('rewards');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('missions');
	}
}