<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRewardsTable extends Migration {

	public function up()
	{
		Schema::create('rewards', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('target_type', array('mission', 'campaign', 'sticker'));
			$table->bigInteger('target_id')->unsigned();
			$table->integer('coins');
			$table->integer('experience_points');
		});
	}

	public function down()
	{
		Schema::drop('rewards');
	}
}