<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_providers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('metrics', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('metrics', function(Blueprint $table) {
			$table->foreign('mission_id')->references('id')->on('missions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('stickers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_global_stats', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_mission_results', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_mission_results', function(Blueprint $table) {
			$table->foreign('mission_id')->references('id')->on('missions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('quests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_course_stats', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_course_stats', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_providers', function(Blueprint $table) {
			$table->dropForeign('user_providers_user_id_foreign');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->dropForeign('missions_user_id_foreign');
		});
		Schema::table('metrics', function(Blueprint $table) {
			$table->dropForeign('metrics_user_id_foreign');
		});
		Schema::table('metrics', function(Blueprint $table) {
			$table->dropForeign('metrics_mission_id_foreign');
		});
		Schema::table('stickers', function(Blueprint $table) {
			$table->dropForeign('stickers_user_id_foreign');
		});
		Schema::table('user_global_stats', function(Blueprint $table) {
			$table->dropForeign('user_global_stats_user_id_foreign');
		});
		Schema::table('user_mission_results', function(Blueprint $table) {
			$table->dropForeign('user_mission_results_user_id_foreign');
		});
		Schema::table('user_mission_results', function(Blueprint $table) {
			$table->dropForeign('user_mission_results_mission_id_foreign');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->dropForeign('user_courses_user_id_foreign');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->dropForeign('user_courses_course_id_foreign');
		});
		Schema::table('quests', function(Blueprint $table) {
			$table->dropForeign('quests_user_id_foreign');
		});
		Schema::table('user_course_stats', function(Blueprint $table) {
			$table->dropForeign('user_course_stats_course_id_foreign');
		});
		Schema::table('user_course_stats', function(Blueprint $table) {
			$table->dropForeign('user_course_stats_user_id_foreign');
		});
	}
}