<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Course extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'objective', 'authors', 'tags', 'image', 'campaigns');

	public function authors()
	{
		return $this->hasMany('App\User');
	}

	public function campaigns()
	{
		return $this->hasMany('App\Campaign');
	}

}