<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('location');
			$table->string('title');
			$table->string('address')->nullable();
			$table->string('detail')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}