<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerTable extends Migration {

	public function up()
	{
		Schema::create('customer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('fullname', 60);
			$table->string('email', 60);
			$table->string('handphone', 12)->unique();
			$table->string('username', 20)->unique();
			$table->string('password', 50);
		});
	}

	public function down()
	{
		Schema::drop('customer');
	}
}