<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryOrdersTable extends Migration {

	public function up()
	{
		Schema::create('inventory_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_qty');
			$table->date('order_date');
			$table->integer('vendor_id')->unsigned();
			$table->integer('item_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('inventory_orders');
	}
}