<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('gender', 1)->default('m');
			$table->string('email', 100)->unique();
			$table->string('password', 100);
			$table->integer('shift_id')->unsigned();
			$table->string('status', 1);
			$table->string('type', 3);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}