<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMaintenanceRecordsTable extends Migration {

	public function up()
	{
		Schema::create('maintenance_records', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100)->unique();
			$table->string('is_sheduled', 1);
			$table->string('frequency', 100)->nullable();
			$table->string('status', 10);
			$table->integer('equipment_id')->unsigned();
			$table->timestamp('closed_on')->nullable();
			$table->integer('reason_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('schedule_id');
			$table->text('description')->nullable();
			$table->string('run_at', 50)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('maintenance_records');
	}
}