<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIntegrationsTable extends Migration {

	public function up()
	{
		Schema::create('integrations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('optix_organization_id');
			$table->string('qbo_organization_id');
			$table->string('access_token')->nullable();
			$table->string('refresh_token');
			$table->json('settings');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('integrations');
	}
}