<?php

namespace App\AppEvents;

class Ticket extends Eloquent {

	protected $table = 'tickets';
	public $timestamps = true;
	protected $fillable = array('name', 'description', 'first_name', 'last_name', 'email', 'company', 'dietary');

	public function user()
	{
		return $this->belongsTo('App\Users\User');
	}

	public function event()
	{
		return $this->belongsTo('App\AppEvents\Event');
	}

	public function venue()
	{
		return $this->belongsTo('App\AppEvents\Venue');
	}

	public function dates()
	{
		return $this->belongsToMany('App\AppEvents\Date');
	}

}