<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'name', 'price', 'status', 'description', 'quantity_order', 'dimension', 'store_id');

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function tags()
	{
		return $this->hasMany('App\Models\Tag');
	}

	public function rate()
	{
		return $this->hasMany('App\Models\ProductRate');
	}

}