<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductRate extends Eloquent {

	protected $table = 'product_rates';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'product_id', 'rate');

	public function product()
	{
		return $this->belongsTo('App\Models\Product');
	}

}