<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('phone', 15)->unique();
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->unique()->nullable();
			$table->text('location')->nullable();
			$table->enum('status', array('deactivate', 'active'));
			$table->integer('v_code')->nullable()->default('2023');
			$table->timestamp('v_code_expired')->nullable();
			$table->string('wallet_passcode')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}