<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = false;

    public function notifications()
    {
        return $this->hasMany('Notification', 'userid', 'user_id');
    }

    public function messages()
    {
        return $this->hasMany('Message', 'userid', 'user_id');
    }

    public function scripts()
    {
        return $this->hasMany('Script', 'scripter_id', 'userid');
    }

    public function subscription()
    {
        return $this->hasOne('Subscription', 'userid', 'userid');
    }

}