<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('DEATH', 'LEVELUP', 'NONE'));
			$table->integer('user_id')->unsigned()->index();
			$table->text('content');
			$table->boolean('seen');
			$table->timestamp('created_at');
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}