<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('service', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('service')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service', function(Blueprint $table) {
			$table->foreign('city')->references('id')->on('city')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('service', function(Blueprint $table) {
			$table->dropForeign('service_parent_id_foreign');
		});
		Schema::table('service', function(Blueprint $table) {
			$table->dropForeign('service_city_foreign');
		});
	}
}