<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('status')->nullable()->default(1);
			$table->json('name')->nullable();
			$table->float('price')->nullable();
			$table->integer('period_count')->nullable();
			$table->enum('period_type', array('days', 'weeks', 'months', 'years'))->nullable();
			$table->json('content')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}