<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAreasTable extends Migration {

	public function up()
	{
		Schema::create('areas', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('status')->nullable()->default(1);
			$table->integer('country_id')->unsigned();
			$table->integer('area_id')->unsigned()->nullable();
			$table->json('name')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('areas');
	}
}