<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Criterio extends Model 
{

    protected $table = 'criterios';
    public $timestamps = true;

    public function plataforma()
    {
        return $this->belongsTo('Plataforma');
    }

    public function eventos()
    {
        return $this->belongsToMany('Evento')->with-pivot(valor);
    }

    public function alertas()
    {
        return $this->belongsToMany('Alerta')->with-pivot(valor,operacion);
    }

}