<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Producto extends Model 
{

    protected $table = 'productos';
    public $timestamps = true;
    protected $fillable = array('tienda_id');

    public function procesos()
    {
        return $this->hasMany('Proceso');
    }

    public function tienda()
    {
        return $this->belongsTo('Tienda');
    }

    public function credenciales()
    {
        return $this->belongsToMany('Credencial');
    }

}