<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsuariosTable extends Migration {

	public function up()
	{
		Schema::create('usuarios', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->string('random', 255);
			$table->timestamps();
			$table->boolean('validado')->default(0);
			$table->boolean('activo')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('usuarios');
	}
}