<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Usuario extends Model 
{

    protected $table = 'usuarios';
    public $timestamps = true;
    protected $fillable = array('email', 'password');

    public function prescripciones()
    {
        return $this->hasMany('Prescripcion');
    }

    public function licencias()
    {
        return $this->hasMany('Licencia');
    }

    public function identidades()
    {
        return $this->hasMany('Identidad');
    }

    public function perfiles()
    {
        return $this->hasMany('Perfil');
    }

}