<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Identifiant extends Model 
{

    protected $table = 'identifiants';
    public $timestamps = true;
    protected $fillable = array('id_categorie', 'id_utilisateur', 'prenom', 'nom', 'date_naissance', 'lieu_naissance', 'photo', 'email', 'telephone', 'login', 'mot_pass', 'nom_table_indexe', 'etat', 'commentaire_etat', 'date_etat', 'annee_academique');
    protected $visible = array('id_categorie', 'id_utilisateur', 'prenom', 'nom', 'date_naissance', 'lieu_naissance', 'photo', 'email', 'telephone', 'login', 'mot_pass', 'nom_table_indexe', 'etat', 'commentaire_etat', 'date_etat', 'annee_academique');

    public function categorie()
    {
        return $this->belongsTo('App\Categorie', 'id_categorie');
    }

    public function tuteur()
    {
        return $this->belongsTo('App\Tuteur', 'id_utilisateur');
    }

    public function enseignant()
    {
        return $this->belongsTo('App\Enseignant', 'id_utilisateur');
    }

    public function eleve()
    {
        return $this->belongsTo('App\Eleve', 'id_utilisateur');
    }

    public function administrateur()
    {
        return $this->belongsTo('App\Administrateur', 'id_utilisateur');
    }

}