<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Classe_mere extends Model 
{

    protected $table = 'classes_mere';
    public $timestamps = true;
    protected $fillable = array('nom_classe_mere', 'id_section', 'cycle', 'etat', 'annee_academique');
    protected $visible = array('nom_classe_mere', 'id_section', 'cycle', 'etat', 'annee_academique');

    public function classe()
    {
        return $this->hasMany('App\Classe', 'id_classe_mere');
    }

    public function serie_classe_mere()
    {
        return $this->hasMany('App\Serie_classe_mere', 'id_classe_mere');
    }

    public function section()
    {
        return $this->belongsTo('App\Section', 'id_section');
    }

    public function fnc_parametre_type_transaction()
    {
        return $this->hasMany('Modules\Finance\Entities\Fnc_parametre_type_transaction', 'id_classe_mere');
    }

}