<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Faire_classe extends Model 
{

    protected $table = 'faire_classes';
    public $timestamps = true;
    protected $fillable = array('id_classe', 'id_eleve', 'annee_academique', 'moyenne', 'etat');
    protected $visible = array('id_classe', 'id_eleve', 'annee_academique', 'moyenne', 'etat');

    public function classe()
    {
        return $this->belongsTo('App\Classe', 'id_classe');
    }

    public function eleve()
    {
        return $this->belongsTo('App\Eleve', 'id_eleve');
    }

    public function bulletin()
    {
        return $this->hasMany('App\Bulletin', 'id_faire_classe');
    }

    public function sanction()
    {
        return $this->hasMany('App\Sanction', 'id_faire_classe');
    }

}