<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Section extends Model 
{

    protected $table = 'sections';
    public $timestamps = true;
    protected $fillable = array('id_section', 'id_etabissement', 'etat', 'nom_section', 'annee_academique');
    protected $visible = array('id_section', 'id_etabissement', 'etat', 'nom_section', 'annee_academique');

    public function classe_mere()
    {
        return $this->hasMany('App\Classe_mere', 'id_section');
    }

    public function etabissement()
    {
        return $this->belongsTo('App\Etablissement', 'id_etabissement');
    }

    public function section()
    {
        return $this->belongsTo('App\Section', 'id_section');
    }

    public function serie()
    {
        return $this->hasMany('App\Serie', 'id_section');
    }

}