<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateElevesTable extends Migration {

	public function up()
	{
		Schema::create('eleves', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_categorie')->unsigned();
			$table->integer('id_tuteur')->unsigned()->nullable();
			$table->string('statut', 255)->nullable();
			$table->boolean('etat')->default(0);
			$table->string('matricule', 255)->nullable();
			$table->string('annee_academique', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('eleves');
	}
}