<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEvaluation3Table extends Migration {

	public function up()
	{
		Schema::create('evaluation3', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_participe')->unsigned()->nullable();
			$table->integer('id_eleve')->unsigned();
			$table->integer('id_matiere')->unsigned();
			$table->integer('id_classe')->unsigned();
			$table->timestamps();
			$table->decimal('note')->nullable();
			$table->integer('coefficient');
			$table->string('annee_academique', 255)->nullable();
			$table->integer('id_enseignant')->unsigned()->nullable();
			$table->date('date_evaluation');
			$table->boolean('etat')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('evaluation3');
	}
}