<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLawyersTable extends Migration {

	public function up()
	{
		Schema::create('lawyers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->integer('region_id');
			$table->string('address', 255);
			$table->text('scheme');
			$table->tinyInteger('is_active');
			$table->timestamps();
			$table->timestamp('updated_at');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('lawyers');
	}
}