<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('channel_id')->unsigned();
			$table->string('name', 50);
			$table->string('email', 30);
			$table->integer('email_is_verified')->default('0');
			$table->string('email_verification_code', 15)->nullable();
			$table->string('msisdn', 20);
			$table->date('birthdate')->nullable();
			$table->integer('gender')->nullable();
			$table->string('regist_token', 250)->nullable();
			$table->string('code', 15)->nullable();
			$table->integer('role_id')->unsigned();
			$table->integer('status')->default('0');
			$table->string('photo', 150)->nullable();
			$table->text('etc')->nullable();
			$table->string('password', 200)->nullable();
			$table->integer('login_type')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}