<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentWosTable extends Migration {

	public function up()
	{
		Schema::create('comment_wos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('work_order_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->text('description');
			$table->integer('status')->default('0');
			$table->string('photo', 100)->nullable();
			$table->integer('is_read')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('comment_wos');
	}
}