<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssetsTable extends Migration {

	public function up()
	{
		Schema::create('assets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('team_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->integer('item_id')->unsigned()->nullable();
			$table->integer('building_id')->unsigned();
			$table->integer('floor_id')->unsigned();
			$table->integer('room_id')->unsigned();
			$table->string('identifier', 100)->nullable();
			$table->string('code', 15)->nullable();
			$table->string('name', 100);
			$table->string('model', 100);
			$table->string('picture', 200)->nullable();
			$table->integer('price')->default('0');
			$table->integer('qty')->nullable();
			$table->integer('status')->default('0');
			$table->text('description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('assets');
	}
}