<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFloorsTable extends Migration {

	public function up()
	{
		Schema::create('floors', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('building_id')->unsigned();
			$table->string('code', 10)->nullable();
			$table->string('name', 15);
			$table->integer('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('floors');
	}
}