<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartsTable extends Migration {

	public function up()
	{
		Schema::create('parts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100)->nullable();
			$table->text('description')->nullable();
			$table->integer('price');
			$table->string('code', 50)->nullable();
			$table->integer('status')->default('0');
			$table->string('type', 55)->nullable();
			$table->integer('qty');
			$table->integer('asset_id')->unsigned();
			$table->string('photo', 100)->nullable();
			$table->string('model', 10)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('parts');
	}
}