<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Team extends Model 
{

    protected $table = 'teams';
    public $timestamps = true;

    public function asset()
    {
        return $this->hasMany('App\Asset', 'team_id');
    }

    public function building()
    {
        return $this->hasMany('App\Building', 'team_id');
    }

    public function service()
    {
        return $this->hasMany('App\Service', 'team_id');
    }

    public function channel()
    {
        return $this->hasMany('App\Channel', 'team_id');
    }

    public function admin()
    {
        return $this->hasOne('App\Admin', 'team_id');
    }

}