<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('invoice_products', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('invoice_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('invoice_products', function(Blueprint $table) {
			$table->dropForeign('invoice_products_invoice_id_foreign');
		});
		Schema::table('invoice_products', function(Blueprint $table) {
			$table->dropForeign('invoice_products_product_id_foreign');
		});
	}
}