<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrescriptionsTable extends Migration {

	public function up()
	{
		Schema::create('prescriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('doctor_id');
			$table->integer('patient_id');
			$table->date('date')->nullable();
			$table->longText('history')->nullable();
			$table->longText('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('prescriptions');
	}
}