<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PatientDocument extends Eloquent {

	protected $table = 'patient_documents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('patient_id', 'title', 'attachment');

	public function patient()
	{
		return $this->belongsTo('Models\Patient', 'patient_id');
	}

}