<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TimeSchedul extends Eloquent {

	protected $table = 'time_schedules';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('doctor_id', 'day', 'time_from', 'time_to', 'appointments_duration', 'notes');

	public function doctor()
	{
		return $this->belongsTo('Models\Doctor', 'doctor_id');
	}

}