<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BedAllotment extends Model 
{

    protected $table = 'bed_allotments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('patient_id', 'date_from', 'date_to', 'notes');

    public function bed()
    {
        return $this->belongsTo('Models\Bed', 'bed_id');
    }

}